/*
 * Decompiled with CFR 0.152.
 */
package com.tacompress;

import com.yahoo.platform.yui.compressor.CssCompressor;
import com.yahoo.platform.yui.compressor.JavaScriptCompressor;
import jargs.gnu.CmdLineParser;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.ArrayList;
import org.mozilla.javascript.ErrorReporter;
import org.mozilla.javascript.EvaluatorException;

public class TaCompress {
    private static final String JS_EXT = ".js";
    private static final String JS_MIN_EXT = ".min.js";
    private static final String CSS_EXT = ".css";
    private static final String CSS_MIN_EXT = ".min.css";

    public static void main(String[] args) throws FileNotFoundException, UnsupportedEncodingException {
        CmdLineParser parser = new CmdLineParser();
        CmdLineParser.Option dirOption = parser.addStringOption("dir");
        String baseDir = "";
        try {
            File dir;
            parser.parse(args);
            baseDir = (String)parser.getOptionValue(dirOption);
            if (baseDir == null) {
                baseDir = ".";
            }
            if (!(dir = new File(baseDir)).exists() || !dir.isDirectory()) {
                TaCompress.usage();
                System.exit(1);
            }
        }
        catch (CmdLineParser.IllegalOptionValueException e) {
            e.printStackTrace();
        }
        catch (CmdLineParser.UnknownOptionException e) {
            e.printStackTrace();
        }
        System.out.println(baseDir);
        ArrayList<File> files = TaCompress.getListFiles(baseDir);
        TaCompress.removeMinFiles(files);
        TaCompress.buildMinFiles(files);
    }

    public static void usage() {
        System.out.println("\u6267\u884c\u65b9\u6cd5:java -jar comparess.jar --dir d:/path/");
    }

    public static void removeMinFiles(ArrayList<File> files) {
        if (!(files instanceof ArrayList)) {
            return;
        }
        String fileString = null;
        int i = 0;
        while (i < files.size()) {
            File file = files.get(i);
            fileString = file.toString().toLowerCase();
            if (fileString.endsWith(JS_MIN_EXT) || fileString.endsWith(CSS_MIN_EXT)) {
                System.out.println("delete file:" + fileString);
                file.delete();
            }
            ++i;
        }
    }

    public static void buildMinFiles(ArrayList<File> files) {
        if (!(files instanceof ArrayList)) {
            return;
        }
        InputStreamReader file_in = null;
        OutputStreamWriter file_out = null;
        String charset = "UTF-8";
        int i = 0;
        while (i < files.size()) {
            String outFilePath;
            String inFilePath;
            File file = files.get(i);
            if (file.toString().toLowerCase().endsWith(JS_EXT) && !file.toString().toLowerCase().endsWith(JS_MIN_EXT)) {
                inFilePath = file.toString();
                outFilePath = inFilePath.substring(0, inFilePath.length() - JS_EXT.length()).concat(JS_MIN_EXT);
                final String localFilename = inFilePath;
                try {
                    file_in = new InputStreamReader((InputStream)new FileInputStream(inFilePath), charset);
                    JavaScriptCompressor compressor = new JavaScriptCompressor(file_in, new ErrorReporter(){

                        @Override
                        public void warning(String message, String sourceName, int line, String lineSource, int lineOffset) {
                            System.err.println("\n[WARNING] in " + localFilename);
                            if (line < 0) {
                                System.err.println("  " + message);
                            } else {
                                System.err.println("  " + line + ':' + lineOffset + ':' + message);
                            }
                        }

                        @Override
                        public void error(String message, String sourceName, int line, String lineSource, int lineOffset) {
                            System.err.println("[ERROR] in " + localFilename);
                            if (line < 0) {
                                System.err.println("  " + message);
                            } else {
                                System.err.println("  " + line + ':' + lineOffset + ':' + message);
                            }
                        }

                        @Override
                        public EvaluatorException runtimeError(String message, String sourceName, int line, String lineSource, int lineOffset) {
                            this.error(message, sourceName, line, lineSource, lineOffset);
                            return new EvaluatorException(message);
                        }
                    });
                    ((Reader)file_in).close();
                    file_in = null;
                    file_out = new OutputStreamWriter((OutputStream)new FileOutputStream(outFilePath), charset);
                    compressor.compress(file_out, -1, true, false, false, false);
                    ((Writer)file_out).close();
                    file_out = null;
                    System.out.println("minify js:" + outFilePath);
                }
                catch (IOException | EvaluatorException e) {
                    e.printStackTrace();
                }
            } else if (file.toString().toLowerCase().endsWith(CSS_EXT) && !file.toString().toLowerCase().endsWith(CSS_MIN_EXT)) {
                inFilePath = file.toString();
                outFilePath = inFilePath.substring(0, inFilePath.length() - CSS_EXT.length()).concat(CSS_MIN_EXT);
                try {
                    file_in = new InputStreamReader((InputStream)new FileInputStream(inFilePath), charset);
                    CssCompressor compressor = new CssCompressor(file_in);
                    ((Reader)file_in).close();
                    file_in = null;
                    file_out = new OutputStreamWriter((OutputStream)new FileOutputStream(outFilePath), charset);
                    compressor.compress(file_out, -1);
                    ((Writer)file_out).close();
                    file_out = null;
                    System.out.println("minify css:" + outFilePath);
                }
                catch (FileNotFoundException | UnsupportedEncodingException e) {
                    e.printStackTrace();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            ++i;
        }
    }

    public static ArrayList<File> getListFiles(Object obj) {
        File directory = null;
        directory = obj instanceof File ? (File)obj : new File(obj.toString());
        ArrayList<File> files = new ArrayList<File>();
        if (directory.isFile()) {
            files.add(directory);
            return files;
        }
        if (directory.isDirectory()) {
            File[] fileArr = directory.listFiles();
            int i = 0;
            while (i < fileArr.length) {
                File fileOne = fileArr[i];
                files.addAll(TaCompress.getListFiles(fileOne));
                ++i;
            }
        }
        return files;
    }
}

